(function(){
    'use strict';

    /**
     * init autocomplete one time only
     * @param {Object} context
     */
    var initAutocomplete = function(context){

        var listenerHandle;

        if(!context.params.enabled){

            context.params.enabled = true;

            //init input autocomplete
            context.params.autocomplete = new window.google.maps.places.Autocomplete(context.params.$input.get(0));

            //autocomplete listener
            listenerHandle = window.google.maps.event.addListener(context.params.autocomplete, 'place_changed', function(){

                var place, start, end;

                //get choosen place
                place = context.params.autocomplete.getPlace();

                if(place && place.geometry){

                    //get points
                    start = new window.google.maps.LatLng(context.params.startLatitude, context.params.startLongitude);
                    end = new window.google.maps.LatLng(place.geometry.location["lat"](), place.geometry.location["lng"]());

                    //trigger set directions event
                    context.observer.$root.trigger('jplist.directions.changed', [start, end]);
                }
            });

        }
    };

    /**
     * get data from store
     * @param {Object} context
     */
    var getDataFromStore = function(context){

        var $store = context.$control.parents('[data-type="store"]');

        if($store.length > 0){

            context.params.startLatitude = Number($store.attr('data-latitude')) || 0;
            context.params.startLongitude = Number($store.attr('data-longitude')) || 0;
        }
    };

    /**
     * Set control status
     * @param {Object} context
     * @param {jQuery.fn.jplist.StatusDTO|Array.<jQuery.fn.jplist.StatusDTO>} status
     * @param {boolean} restoredFromStorage - is status restored from storage
     */
    var setStatus = function(context, status, restoredFromStorage){

        //if(status && status.data && !status.data.place){}
    };

    /**
     * Get control status
     * @param {Object} context
     * @param {boolean} isDefault - if true, get default (initial) control status; else - get current control status
     * @return {jQuery.fn.jplist.StatusDTO}
     */
    var getStatus = function(context, isDefault) {

        var status = null
            ,data;

        if(isDefault){
            data = new jQuery.fn.jplist.controls.GoogleMapDirectionsDTO(null);
        }
        else{
            data = new jQuery.fn.jplist.controls.GoogleMapDirectionsDTO(context.params.autocomplete.getPlace());
        }

        //create status object
        status = new jQuery.fn.jplist.StatusDTO(
            context.name
            ,context.action
            ,context.type
            ,data
            ,context.inStorage
            ,context.inAnimation
            ,context.isAnimateToTop
            ,context.inDeepLinking
        );

        return status;
    };

    /**
     * init events
     * @param {Object} context
     */
    var initEvents = function(context){

        /**
         * on input change
         */
        context.params.$input.on('click', function(e){
            e.preventDefault();
            return false;
        });

        /**
         * on label click
         */
        context.params.$label.on('click', function(e){

            e.preventDefault();

            //get data from store
            getDataFromStore(context);

            //init autocomplete one time only
            initAutocomplete(context);

            //show / hide autocomplete
            context.params.$input.toggle(0);

            return false;
        });

        /**
         * on directions error
         */
        context.observer.$root.on('jplist.directions.error', function(e, status, start, end){

            if(context.params.startLatitude === start.lat() && context.params.startLongitude === start.lng()){

                var $error = $('<div class="jplist-direction-err">No results found</div>');

                context.params.$input.after($error);

                window.setTimeout(function(){
                    $error.fadeOut({
                        complete: function(){
                            $error.remove();
                        }
                    });
                }, 1000);
            }
        });
    };

    /**
     * Star Rating Item Control View
     * @constructor
     * @param {Object} context
     */
    var Init = function(context){

        context.params = {
            $label: context.$control.find('[data-type="directions-label"]')
            ,$input: context.$control.find('[data-type="directions-input"]')
            ,enabled: false
            ,autocomplete: null
            ,startLatitude: 0
            ,startLongitude: 0
        };

        //init events
        initEvents(context);

        return jQuery.extend(this, context);
    };

    /**
     * Get control status
     * @param {boolean} isDefault - if true, get default (initial) control status; else - get current control status
     * @return {jQuery.fn.jplist.StatusDTO}
     */
    Init.prototype.getStatus = function(isDefault){
        return getStatus(this, isDefault);
    };

    /**
     * Set Status
     * @param {jQuery.fn.jplist.StatusDTO} status
     * @param {boolean} restoredFromStorage - is status restored from storage
     */
    Init.prototype.setStatus = function(status, restoredFromStorage){
        setStatus(this, status, restoredFromStorage);
    };

    /**
     * Google Maps Directions Item Control View
     * @constructor
     * @param {Object} context
     */
    jQuery.fn.jplist.itemControls.GoogleMapDirections = function(context){
        return new Init(context);
    };

    /**
     * static control registration
     */
    jQuery.fn.jplist.itemControlTypes['google-map-directions'] = {
        className: 'GoogleMapDirections'
        ,options: {}
    };

})();